<?php
$to = "info@gooddeal971.com"; // set your inbox here

function field($name) {
  return isset($_POST[$name]) ? trim(stripslashes($_POST[$name])) : "";
}

$honeypot = field("website");
if ($honeypot !== "") {
  header("Location: " . ($_POST["lang"] === "en" ? "en.html#contact" : "index.html#contact"));
  exit;
}

$name = field("name");
$email = field("email");
$phone = field("phone");
$message = field("message");
$lang = field("lang");

if ($name === "" || $email === "" || $message === "") {
  http_response_code(400);
  echo "Missing required fields.";
  exit;
}

if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
  http_response_code(400);
  echo "Invalid email.";
  exit;
}

$subject = ($lang==="en" ? "New Contact — GOOD DEAL 971" : "Nouveau contact — GOOD DEAL 971");
$body = "Nom: $name\nEmail: $email\nTéléphone: $phone\nLangue: $lang\n\nMessage:\n$message\n";
$headers = "From: noreply@gooddeal971.com\r\n";
$headers .= "Reply-To: $email\r\n";
$headers .= "X-Mailer: PHP/" . phpversion();

$sent = @mail($to, $subject, $body, $headers);
if ($sent) {
  header("Location: " . ($lang==="en" ? "en.html#contact" : "index.html#contact"));
} else {
  http_response_code(500);
  echo "Cannot send email right now. Please try again later.";
}
?>